/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ISpecies;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class LookThroughSpyglassEvent {
    @SubscribeEvent
    public static void lookAtEntityThroughSpyglassEvent(LivingEntityUseItemEvent event) {
        ItemStack usedItem = event.getItem();
        Entity entity = event.getEntity();
        if (((Boolean)ConfigGamerules.spyglassBehaviorChange.get()).booleanValue() && !entity.m_183503_().f_46443_ && entity instanceof Player) {
            EntityHitResult entityHitResult;
            Entity entity2;
            HitResult hitresult;
            Player playerIn = (Player)entity;
            if (playerIn.f_19797_ % 20 == 0 && usedItem.m_41720_().equals(Items.f_151059_) && (hitresult = LookThroughSpyglassEvent.raycast((Entity)playerIn, ((Integer)ConfigGamerules.spyglassCheckRange.get()).intValue(), true)).m_6662_() == HitResult.Type.ENTITY && (entity2 = (entityHitResult = (EntityHitResult)hitresult).m_82443_()) instanceof LivingEntity) {
                LivingEntity livingEntityHitResult = (LivingEntity)entity2;
                LookThroughSpyglassEvent.displayEntityData(livingEntityHitResult, playerIn, playerIn.m_183503_());
            }
        }
    }

    public static HitResult raycast(Entity origin, double maxDistance, boolean hitsEntities) {
        Vec3 startPos = origin.m_20299_(1.0f);
        Vec3 rotation = origin.m_20252_(1.0f);
        Vec3 endPos = startPos.m_82520_(rotation.f_82479_ * maxDistance, rotation.f_82480_ * maxDistance, rotation.f_82481_ * maxDistance);
        BlockHitResult hitResult = origin.f_19853_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, origin));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            endPos = hitResult.m_82450_();
        }
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)origin, (Vec3)startPos, (Vec3)endPos, (AABB)origin.m_142469_().m_82369_(rotation.m_82490_(maxDistance *= 5.0)).m_82377_(1.0, 1.0, 1.0), entity -> !entity.m_5833_(), (double)maxDistance);
        if (hitsEntities && entityHitResult != null) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    private static void displayEntityData(LivingEntity target, Player playerIn, Level world) {
        TextComponent name = new TextComponent("");
        if (target instanceof ComplexMob) {
            String entityName;
            ComplexMob entity = (ComplexMob)target;
            String string = entityName = entity instanceof ISpecies ? ((ISpecies)((Object)entity)).getSpeciesName() : entity.m_7755_().getString();
            name.m_130946_((String)(entity.m_6162_() ? "Young " : (String)((Boolean)ConfigGamerules.genderedBreeding.get() != false ? entity.getGenderString() + " " : "") + entityName + " "));
            if (((Boolean)ConfigGamerules.scientificNames.get()).booleanValue()) {
                String useVarName = entity instanceof ISpecies ? "_" + ((ISpecies)((Object)entity)).getRawSpeciesName(entity.getVariant()) : "";
                name.m_130946_("(");
                name.m_7220_((Component)new TranslatableComponent(entity.m_6095_().m_20675_() + useVarName + ".sciname").m_130940_(ChatFormatting.ITALIC));
                name.m_130946_(") ");
            }
            if (!entity.isMale() && entity.m_146764_() > 0 && !((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue()) {
                name.m_130946_("This female is pregnant ");
            }
        } else {
            name.m_130946_((String)(target.m_6162_() ? "Young " : target.m_7755_().getString() + " "));
        }
        int health = (int)(10.0f * target.m_21223_() / target.m_21233_());
        MutableComponent state = LookThroughSpyglassEvent.getHealthState(health);
        name.m_130946_("(");
        name.m_7220_((Component)state);
        name.m_130946_(") ");
        name.m_130946_("(");
        name.m_7220_((Component)LookThroughSpyglassEvent.getThreatLevel(target, playerIn));
        name.m_130946_(")");
        playerIn.m_5661_((Component)name, true);
    }

    private static MutableComponent getHealthState(int health) {
        switch (health) {
            case 8: 
            case 9: 
            case 10: {
                return new TextComponent("Healthy").m_130940_(ChatFormatting.GREEN);
            }
            case 5: 
            case 6: 
            case 7: {
                return new TextComponent("Injured").m_130940_(ChatFormatting.YELLOW);
            }
            case 2: 
            case 3: 
            case 4: {
                return new TextComponent("Wounded").m_130940_(ChatFormatting.RED);
            }
            case 0: 
            case 1: {
                return new TextComponent("Almost Dead").m_130940_(ChatFormatting.DARK_RED);
            }
        }
        return new TextComponent("");
    }

    private static MutableComponent getThreatLevel(LivingEntity target, Player player) {
        int val = ComplexMob.getEcoLevel((LivingEntity)player) - ComplexMob.getEcoLevel(target);
        if (val > 4) {
            return new TextComponent("Harmless").m_130940_(ChatFormatting.GREEN);
        }
        if (val > 2) {
            return new TextComponent("Mild threat").m_130940_(ChatFormatting.YELLOW);
        }
        if (val > 0) {
            return new TextComponent("Caution").m_130940_(ChatFormatting.YELLOW);
        }
        if (val > -4) {
            return new TextComponent("Dangerous").m_130940_(ChatFormatting.RED);
        }
        return new TextComponent("Deadly").m_130940_(ChatFormatting.DARK_RED);
    }
}

